<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('countries_payment_modes', function (Blueprint $table) {
            $table->foreign(['country_id'], 'cpm_country')->references(['id'])->on('countries')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['payment_mode_id'], 'cpm_payment')->references(['id'])->on('payment_modes')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('countries_payment_modes', function (Blueprint $table) {
            $table->dropForeign('cpm_country');
            $table->dropForeign('cpm_payment');
        });
    }
};
