<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('uuid');
            $table->float('amount_paid', 20)->unsigned();
            $table->unsignedBigInteger('order_id')->nullable()->index('order_id');
            $table->unsignedBigInteger('subscription_id')->nullable()->index('subscription_id');
            $table->unsignedSmallInteger('transaction_status_id')->index('transaction_status_id');
            $table->unsignedBigInteger('wallet_id')->index('wallet_id');
            $table->unsignedSmallInteger('transaction_type_id')->index('transaction_type_id');
            $table->timestamp('created_at')->useCurrent();
            $table->unsignedBigInteger('created_by');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
};
