<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property integer $order_id
 * @property integer $subscription_id
 * @property integer $transaction_status_id
 * @property integer $transaction_type_id
 * @property string $code
 * @property float $amount_paid
 * @property integer $wallet_id
 * @property string $created_at
 * @property integer $created_by
 * @property Order $order
 * @property Subscription $subscription
 * @property TransactionStatus $transactionStatus
 * @property TransactionType $transactionType
 */
class Transaction extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['order_id', 'subscription_id', 'transaction_status_id', 'transaction_type_id', 'uuid', 'amount_paid', 'wallet_id','request','response','callback_response', 'created_at', 'created_by'];
    protected $hidden = [ 'created_at', 'created_by', 'updated_by', 'updated_at'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo('App\Models\api\v1\Order');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function subscription()
    {
        return $this->belongsTo('App\Models\api\v1\Subscription');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function transactionStatus()
    {
        return $this->belongsTo('App\Models\api\v1\TransactionStatus');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function transactionType()
    {
        return $this->belongsTo('App\Models\api\v1\TransactionType');
    }
}
