<?php

namespace App\Http\Controllers\api\v1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;



class UriController extends Controller
{


    /**
     * List endpoints
     */
    public function well_known_uri(Request $request)
    {
        $routeCollection = Route::getRoutes();

        $data =  [];
        foreach ($routeCollection as $value)
        {
            if (!str_contains($value->getActionName(), "App\Http\Controllers") or
                strtoupper($value->getName()) == "WELL_KNOW_URI"
            )
                continue;

            $data[] = [
                "NAME"      => strtoupper($value->getName()),
                "METHOD"    => $value->methods()[0] ,
                "PATH"      => env('APP_URL').'/'.$value->uri()
            ];
        }

       $wifi = ["label" => "Payez un pass", "url" => "https://example.com"];
        $response = ["wifi" => $wifi, "baseUrl" => env('APP_URL'), "routes" => $data];
        return response()->json(['success' => true,  'message' => 'List of Endpoints to retrieve', 'data' => $response]);

    }

}
