<?php

namespace App\Http\Controllers\api\v1;

use App\Helpers\SerializerHelpers;
use App\Models\api\v1\AccessTokens;
use App\Models\api\v1\ApiKey;
use App\Models\User;
use App\Services\ApiKeyService;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use App\Services\CinetPayService;
use App\Models\api\v1\Order;
use App\Models\api\v1\Transaction;
use App\Models\api\v1\TransactionStatus;
use App\Models\api\v1\OrderStatus;
use App\Models\api\v1\UsersRolesSpace;
use App\Models\api\v1\UserRole;
use App\Models\api\v1\Device;







class TransactionController extends Controller
{
    
    /**
     * Gestion des callback CinetPay
     */
    public function processingCallbackCinetPay(Request $request)
    {
        $data = $request->all();
        $cinetpay = new CinetPayService();
        $isOk = false;
        $order = Order::where('uuid', $data['cpm_trans_id'])->first();
        if (!empty($order) && $order->remaining_amount == $data['cpm_amount']) {
            if($order->order_status_id != OrderStatus::where("name", "CONFIRMED")->first()->id){
                return response()->json(['success' => false, "message" => "Commande deja traitée"]);
            }
           
            $cinetpay = new CinetPayService();
            $cinetpay->processingCallback($data, $isOk);
            if ($isOk) {
                $transaction = Transaction::where("order_id", $order->id)->first();
                $transaction->callback_response = json_encode($data);
                $transaction->transaction_status_id = TransactionStatus::where('name', "APPROVED")->first()->id;
                $transaction->save();
                ///////////update order
                $order->order_status_id = OrderStatus::where("name", "PAID")->first()->id;
                $order->save();
                $this->sendNotifs($order);
            }
        }
        if (!$isOk) {
            return response()->json(['success' => false, "message" => "Echec de mise à jour de la transaction"]);
        }
        return response()->json(['success' => true, "message" => "Mise a jour effectuée avec succès"]);
    }
    
    private function sendNotifs($order){
        $userIds = array();
        if(empty($order)){
            return;
        }
        $deviceTokens = array();
        $clientId = $order->customer->id;
        array_push($userIds,$clientId);
        //////merchands 
        $userInSpace = UsersRolesSpace::where('space_id', $order->space_id)->get()->pluck('user_role_id');
        $userRoles = UserRole::whereIn('id', $userInSpace)->where('role_id', 3)->get();
        foreach ($userRoles as $userRole) {
            if(!in_array($userRole?->user?->id,$userIds)){
                array_push($userIds,$userRole?->user?->id);
            }
        }
        $devicesTokens = Device::whereIn('user_id', $userIds)->get()->pluck('device_token')->toArray();
        if (!empty($devicesTokens)) {
                NotificationHelpers::sendNotification(
                    [$devicesTokens],
                    "Information sur la commande ",
                    "Paiement de la commande N°".$rder->order_number." effectué avec succès",
                    ["Action" => "","order_mumber"=>$order->order_number]
                );
        }
    }
    
    private function getFlexData(string $token): array
    {

        return $data = [
            "solde" => 30,
            'transactions' => [
                [
                    "id" => 124,
                    "montant"=> 10,
                    "type"=> "SORTANT",
                    "commentaire"=> "Test de paiement marchand",
                    "statut"=> "valide",
                    "etat"=> "valide",
                    "user"=> 720,
                    "ref"=> "pay659c20e5150ab",
                    "partenaire"=> 38,
                    "transaction"=> "transaction",
                    "created_at"=> "2024-01-08 16:20:53",
                    "updated_at"=> "2024-01-08 16:20:56",
                    "avantages"=> null,
                    "beneficiaire"=> "KY KADER",
                    "label"=> "KY KADER",
                    "nature"=> "Paiement",
                    "operateur"=> ""
                ],
                [
                    "id" => 122,
                    "montant"=> 10,
                    "type"=> "SORTANT",
                    "commentaire"=> "Test de paiement marchand",
                    "statut"=> "valide",
                    "etat"=> "valide",
                    "user"=> 720,
                    "ref"=> "con6598f531d6e66",
                    "partenaire"=> 38,
                    "transaction"=> "transaction",
                    "created_at"=> "2024-01-08 16:20:53",
                    "updated_at"=> "2024-01-08 16:20:56",
                    "avantages"=> null,
                    "beneficiaire"=> "KY KADER",
                    "label"=> "KY KADER",
                    "nature"=> "Paiement",
                    "operateur"=> ""
                ]
            ]
        ];

    }
    
    /**
     * Generate and Send Code
     */
    public function list(Request $request): JsonResponse
    {

        $get_authorized_api_key = ApiKey::where([['name', 'Flex'], ['is_active', 1]])->first();
        if (!$get_authorized_api_key)
        {
            return $this->ReturnResponse(false, "An error occurred. Please try again!", [], 401);
        }


        //@TODO:
        $access_token = AccessTokens::create([
            'user_id'               => $request->user()->id,
            'token'                 => Str::random(350),
            'created_by'            => $request->user()->id,
            'expire_at'             => now()->addSeconds(ApiKeyService::getApiKey($request)->token_max_interval),
            'requester_api_key_id'  => ApiKeyService::getApiKey($request)->id,
            'authorized_api_key_id' => $get_authorized_api_key->id,
            'used'                  => 0
        ]);

        $data = $this->getFlexData($access_token->token);

        return $this->ReturnResponse(true, "List Transactions", $data, 200);
    }


    public function userDetails(Request $request, string $token): JsonResponse
    {

        $access_token = AccessTokens::where([
            ['token',                   $token],
            ['used',                    0],
            ['expire_at',  '>=',        Carbon::now()],
            ['authorized_api_key_id',   ApiKeyService::getApiKey($request)->id]
        ])->first();

        if (!$access_token)
        {
            return $this->ReturnResponse(false, "Token is not valid", [], 401);
        }

        $user = User::find($access_token->user_id);

        $access_token->update([
            'used'      => 1,
            'used_at'   => now(),
        ]);

        return $this->ReturnResponse(true, "User Details", SerializerHelpers::serializeUser($user));

    }

}

