<?php

namespace App\Http\Controllers\api\v1;

use Log;
use Auth;
use Session;
use Exception;
use Illuminate\Http\Request;
use App\Helpers\Utils;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;



class AdsController extends Controller
{
    /**
     * Get Ads
     * @param Request $request
     * @return JsonResponse
     */
    public function getAds(Request $request): JsonResponse
    {
        try {
            // $url        = env('ADS_MANAGER_API')."/ads/?place=". $request->get('place') ."&destination=".$request->get('destination');
            // $ads        = Utils::makeAdsCall('GET', $url);

            // $data       = ($ads['success'] && !is_null($ads['data'])) ? [$ads['data']] : [];
            // $success    = is_null($data)? false : true;
            $data = '[
                    {
                        "type":"image",
                        "url":"http://192.168.1.9/amc-backend/public/ads/img2.jpeg",
                        "impression_id":"33c04fcf-8f8f-44f4-9e7f-e633810a2111",
                        "duration":3.0,
                        "redirect_url":"https://webapp-amc.alcyon-partners.net/admin/stock/stocks/list/all"
                    },
                    {
                        "type":"image",
                        "url":"http://192.168.1.9/amc-backend/public/ads/img1.jpeg",
                        "impression_id":"33c04fcf-8f8f-44f4-9e7f-e633810a2111",
                        "duration":3.0,
                        "redirect_url":"https://webapp-amc.alcyon-partners.net/admin/stock/stocks/list/all"
                    },
                    {
                        "type":"video",
                        "url":"http://192.168.1.9/amc-backend/public/ads/th.jpeg",
                        "impression_id":"33c04fcf-8f8f-44f4-9e7f-e633810a2111",
                        "duration":3.0,
                        "redirect_url":"https://webapp-amc.alcyon-partners.net/admin/stock/stocks/list/all"
                    }
        ]';
            $data = json_decode($data, true);
            $message    = is_null($data) ? "Ads not found" : "Ads found";

            return $this->ReturnResponse(true, $message, [$data]);
            // return $this->ReturnResponse($success, $message, $data);
        } catch (Exception $e) {
            $message = "AdsController - getAds - " . $e->getMessage() . " - line: " . $e->getLine() . " - file: " . $e->getFile();
            //Logging de l erreur
            Log::channel('customlog')->error($message);
            return $this->ReturnResponse(false, $message, [], 500);
        }
    }
}
